<?php

namespace App\Controllers;
use App\Models\EnquiryModel;
use App\Libraries\Sms;

class Enquiry extends BaseController
{
    public function index()
    {
        return view('welcome_message');
    }

 
    public function save()
    {
        $validate_fields = [
            'name'  => 'trim|required',
            'mobile' => 'trim|required|numeric|exact_length[10]',
            'email' => 'trim|required|valid_email',
            'enquiry' => 'trim|required'
            
        ];

        if (! $this->validate($validate_fields)) 
        {
            die(json_encode([
                'error' => $this->validator->getErrors(),
                'token' => csrf_hash()
            ]));

        }

        $interested = $this->request->getPost('course_interestfor');
        $type = trim($this->request->getPost('type'));
        $camefrom = $this->request->getPost('camefrom');

        if(empty($camefrom))
        {
            $camefrom = 'Home Page PopUp';
        }

        $enquiry = '';

        $customer_email = 'contact@vectorindia.org';

        if($type == 'corp-enquiry')
        {

            $designation = $this->request->getPost('designation');
            if(!empty($designation))
            {
                $enquiry .= 'Designation: ' . $designation . PHP_EOL;
            }
            
            $company_name = $this->request->getPost('company-name');
            if(!empty($company_name))
            {
                $enquiry .= 'Company Name: ' . $company_name . PHP_EOL;
            }

            $customer_email = 'contact@vectorindia.org';
        }

        $enquiry .= '' . PHP_EOL; 
        $enquiry .= '' .$this->request->getPost('enquiry') . PHP_EOL;   


        $data = [
            'full_name' => $this->request->getPost('name'),
            'mobile' => $this->request->getPost('mobile'),
            'email' => $this->request->getPost('email'),
            'enquiry' => $enquiry,
            'interested' => $interested,
            'type' => $type,
            'camefrom' => $camefrom
        ];

        $mobile = $data['mobile'];

        $session = session();
        $session->set('enquiry_data', $data);
        $session->set('customer_email', $customer_email);

       


        $otp = $this->send_otp($mobile);

        die(json_encode([
            'error' => 0,
            'otp_sent' => 'yes',
            'message' => 'Please validate the OTP',
            'token' => csrf_hash()
        ]));


        


        

    }

    private function save1()
    {
        $session = session();
        $data = $session->get('enquiry_data');

        $customer_email = $session->get('customer_email');


        
        $model = model(EnquiryModel::class);
        $model->save($data);

        $enquiry_id = $model->getInsertID();

        

        $data['maildata'] = $data;

        

        $data['customer_email'] = $customer_email;

        

        $sms = new Sms;
        $ms = $sms->_send_mail('mailview_enquiry', 'Mail from: ' . $data['camefrom'], $data);

        
        die(json_encode([
            'error' => 0,
            'message' => 'Thank you for submitting the details. Our team will contact you soon',

        ]));
    }

    public function validate_otp()
    {
        $send_otp = $this->request->getPost('send_otp');

        $session = session();
        $otp_sent = $session->get('otp_sent');

        

        if( $send_otp == $otp_sent )
        {
            $this->save1();
        }
        else
        {
            die(json_encode([
                'error' => 1,
                'message' => 'Invalid OTP',
             ]));
        }

    }

    private function send_otp($mobile)
    {
        $session = session();

        $otp = $this->rand6digit();
        $session->set('otp_sent', $otp);

        $sms = new Sms;
        $sms_tmplate_old = 'Your OTP for verify mobile number in Registration is %s. -- Vector India';
        $sms_tmplate = 'Your OTP for Verify Mobile Number %s %s -- Vector India';
        $sms_tmplate = sprintf($sms_tmplate, 'is ' . $otp . '.', 'Please enter to validate it.');

        
        $rs = $sms->send($mobile, $sms_tmplate);

        return $otp;
    }

    private function rand6digit(){
        return intval( "0" . rand(1,9) . rand(0,9) . rand(1,9) . rand(0,9) . rand(0,9) . rand(0,9)  );  
    }

    public function resend_otp()
    {
        $resend_otp = (int)$this->request->getPost('resend_otp');
        $mobile = $this->request->getPost('mobile');
        $response = [];
        if($resend_otp === 1)
        {
            $otp = $this->send_otp($mobile);

            $response = [
                'error' => 0,
                'otp_sent' => 'yes',
                'message' => 'OTP Send ',
                'token' => csrf_hash()
            ];
        }
        else
        {
            $response = [
                'error' => 1,
                'otp_sent' => 'no',
                'message' => 'OTP not sent, try again latter',
                'token' => csrf_hash()
            ];
        }

        die(json_encode($response));
        
    }

    public function all()
    {
        $model = model(EnquiryModel::class);
        $data = $model->orderBy('id', 'desc')->findAll();

        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }
}
