<?php

namespace App\Controllers;
use App\Models\RegistrationModel;
use App\Models\CourseModel;
use App\Models\DegreeModel;
use App\Models\EntranceModel;
use App\Models\Entrance_linkModel;
use App\Libraries\Sms;

class Registration extends BaseController
{
    public function index()
    {
        // $link = 'https://www.vectorindia.org/online-registration.html?utm_source=vml&utm_medium=maileru&utm_campaign=vml';
        $data = [
            'utm_source' => $this->request->getPostGet('utm_source'),
            'utm_medium' => $this->request->getPostGet('utm_medium'),
            'utm_campaign' => $this->request->getPostGet('utm_campaign'),
        ];

        $session = session();
        $session->set('utm_data', $data);

        return view('registration/registration', $data);
    }

    public function get_degrees()
    {
        $model = model(DegreeModel::class);
        $data = $model->where('active', 1)
                    ->findAll();

        if(!empty($data))
        {
            $data_ = array_map(function($item){
                return [
                    'id' => $item->id,
                    'name' => $item->name,
                    'pgugothers' => $item->pgugothers,
                    'active' => $item->active == 1 ? 'Yes' : 'No',
                ];
            }, $data);

            $data = [
                'error' => 0,
                'message' => 'Data retrieved',
                'data' => $data_
            ];
        }  
        else
        {
            $data = [
                'error' => 1,
                'message' => 'No Data'
            ];
        }          
                    

        return $this->response->setJSON($data);
    }

    public function get_courses()
    {
        $model = model(CourseModel::class);
        $data = $model->where('active', 1)
                    ->findAll();

        if(!empty($data))
        {
            $data_ = array_map(function($item){
                return [
                    'id' => $item->id,
                    'name' => $item->name,
                    'active' => $item->active == 1 ? 'Yes' : 'No',
                ];
            }, $data);

            $data = [
                'error' => 0,
                'message' => 'Data retrieved',
                'data' => $data_
            ];
        }  
        else
        {
            $data = [
                'error' => 1,
                'message' => 'No Data'
            ];
        }          
                    

        return $this->response->setJSON($data);
    }

    public function register()
    {


        $validate_fields = [
            'name'  => 'trim|required',
            'mobile_number' => 'trim|required|numeric|exact_length[10]',
            'email' => 'trim|required|valid_email',
            
        ];

        if (! $this->validate($validate_fields)) 
        {
            die(json_encode([
                'error' => $this->validator->getErrors(),
                'token' => csrf_hash()
            ]));

        }




         $registration_data = $this->request->getPost();

         $mobile = $registration_data['mobile_number'];
         $email = $registration_data['email'];
         $course_name = $registration_data['courses'];
         
         if( $this->userexists($course_name, $email, $mobile) )
         {
            die(json_encode([
                'error' => 1,
                'token' => csrf_hash(),
                'message' => 'Seems to be you already registered!'
            ]));
         }
         


         $session = session();
         $session->set('registration_data', $registration_data);

         $session->set('utm_data1', $session->get('utm_data'));
         $session->set('utm_data', '');


         $otp = $this->send_otp($mobile);

         die(json_encode([
            'error' => 0,
            'otp_sent' => 'yes',
           
            'token' => csrf_hash()
         ]));

        
    }

    private function userexists($course_name, $email, $mobile)
    {
        

        $model = model(EntranceModel::class);
        $ed = $model->get_entrance_data(['course_name' => $course_name, 'active' => 1]);

        $entranceid = $ed->entranceid;


        $model = model(RegistrationModel::class);
        $model->where([
            'course_name' => $course_name,
            'entranceid'  => $entranceid,
        ]);
        $model->groupStart();
        $model->where('email', $email);
        $model->orWhere('mobile', $mobile);
        $model->groupEnd();
        
        // $sql = $model->getCompiledSelect();
        // echo $sql;

        $data = $model->first();



        // var_dump( !is_null($data) );

        return !is_null($data);
    }

    private function save()
    {

        $session = session();
        $registration_data = $session->get('registration_data');
        $utm_data = $session->get('utm_data1');

        $utm_source = !empty($utm_data['utm_source']) ? $utm_data['utm_source'] : '';
        $utm_medium = !empty($utm_data['utm_medium']) ? $utm_data['utm_medium'] : '';
        $utm_campaign = !empty($utm_data['utm_campaign']) ? $utm_data['utm_campaign'] : '';

        
        list($degree, $degree_category) = explode('_', $registration_data['degrees']);

        $pgugothers = $degree_category;


         $model = model(EntranceModel::class);

         $ed = $model->get_entrance_data(['course_name' => $registration_data['courses'], 'active' => 1]);

         // var_dump(['course_name' => $registration_data['courses'], 'active' => 1], $ed);

         $entranceid = $ed->entranceid;
         $course_name = $registration_data['courses'];
         $email = $registration_data['email'];
        
        $data = [
            'email' => $registration_data['email'],
            'mobile'    => $registration_data['mobile_number'],
            'name'    => $registration_data['name'],
            'pgugothers'    => $pgugothers,
            'course_name' => $registration_data['courses'],
            'entranceid' => $entranceid,
            'utm_campaign' => $utm_campaign,
            'utm_medium' => $utm_medium,
            'utm_source' => $utm_source,
            'degree' => $degree,
            'yop' => $registration_data['yop'],
            'percentage' => $registration_data['perc-marks'],
            'specialization' => $registration_data['specialization']
           
        ];



        

        

        $model = model(RegistrationModel::class);
        $model->save($data);

        $registration_id = $model->getInsertID();

       


        $data['customer_email'] = $email;
        $ms = $this->_send_mail('mailview_registration', 'Vector India - Online Entrance Test - Registration Successful', $data);


        $rs = $this->send_exam_link($email, $course_name, $entranceid);
        if(!empty($rs))
        {
           

            $model->save([
                'id' => $registration_id,
                'exam_invitation_response' => $rs
            ]);   
        }
       
        die(json_encode([
            'error' => 0,
            'message' => "Dear {$data['name']} Thank You for Applying
Online Test Credentials will be sent to your registered email
Please check your mail for further details.
Best Regards VECTOR Team
 

** Important Information **

Test schedule

Date of Test: Test Credentials sent to your registered email",
            
         ]));
    }


    private function send_exam_link($email, $course, $entranceid)
    {   
        

        // https://api.wecreateproblems.com/orgs/:orgName/groups/:groupId/tests/:testId/sendInvites
        // https://api.wecreateproblems.com/orgs/vectorindia/groups/20a581c5-a386-4a57-9da2-7360afcee779/tests/9536b509-4c5e-432d-800c-7281fefec138/sendInvites'
        $model = model(Entrance_linkModel::class);
        $ed = $model->get_entrance_data(['course_name' => $course, 'entranceid' => $entranceid]);



        if( !empty($ed) && $ed->course_name == $course)
        {
           

            $api_key = '9YrZnpCQJh5kxeHDfd8jK2wiRteId24RahpDNJTK';
            
            $json_body = json_encode([
                "sendEmail" => "true", 
                "emailIds" => [$email],
            ]);

            $patterns = [
                '/:orgName/',
                '/:groupId/',
                '/:testId/'
            ];

            $replacements = [
                $ed->organization,
                $ed->groupid,
                $ed->testid
            ];


            $url = preg_replace($patterns, $replacements, $ed->api_link);

           

            $client = \Config\Services::curlrequest();

            $response = $client->setBody($json_body)->request('POST', $url, [

                'headers' => [

                  'content-type' => 'application/json',
                  'x-api-key' => $api_key,

                ],
  
            ]);
  
  
              
            $rs = $response->getBody();

            return $rs;
        }

        return '';        
    }


    public function validate_otp()
    {
        $send_otp = $this->request->getPost('send_otp');

        $session = session();
        $otp_sent = $session->get('otp_sent');



        if( $send_otp == $otp_sent )
        {
            $this->save();
        }
        else
        {
            die(json_encode([
                'error' => 1,
                'message' => 'Invalid OTP',
             ]));
        }

    }

    private function send_otp($mobile)
    {
        $session = session();

        $otp = $this->rand6digit();
        $session->set('otp_sent', $otp);

        $sms = new Sms;
        $rs = $sms->send($mobile, 'Your OTP for verify mobile number in Registration is '.$otp.'. -- Vector India');

        return $otp;
    }

    public function resend_otp()
    {
        $resend_otp = (int)$this->request->getPost('resend_otp');
        $mobile = $this->request->getPost('mobile');
        $response = [];
        if($resend_otp === 1)
        {
            $otp = $this->send_otp($mobile);

            $response = [
                'error' => 0,
                'otp_sent' => 'yes',
                'message' => 'OTP Send ',
                'token' => csrf_hash()
            ];
        }
        else
        {
            $response = [
                'error' => 1,
                'otp_sent' => 'no',
                'message' => 'OTP not sent, try again latter',
                'token' => csrf_hash()
            ];
        }

        die(json_encode($response));
        
    }

    public function get_token()
    {
        die(json_encode([
            'error' => 0,
            'token' => csrf_hash()
         ]));
    }

    private function rand6digit(){
        return intval( "0" . rand(1,9) . rand(0,9) . rand(1,9) . rand(0,9) . rand(0,9) . rand(0,9)  );  
    }

    public function sendmail()
    {
        $data['name'] = 'jagdish';
        $data['customer_email'] = 'jagdish@foreedge.com';

        $sms = new Sms;


        $ms = $this->_send_mail('mailview_registration', 'Vector India - Online Entrance Test - Registration Successful @ ' . date('r'), $data);
        var_dump($ms);

        
        $rs = $sms->send('9492036153', 'Your OTP for verify mobile number in Registration is 10000. -- Vector India');


        var_dump($rs);
    }


    private function _send_mail($mail_template, $subject, $data)
    {
        $sms = new Sms;

        return $sms->_send_mail($mail_template, $subject, $data);
    }

}
