const mariadb = require('mariadb');
// require('dotenv').config();

const pool = mariadb.createPool({
    host: process.env.DB_HOST,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    connectionLimit: 5,
    allowPublicKeyRetrieval: true
});

const collegePool = mariadb.createPool({
    host: process.env.DB_HOST2,
    user: process.env.DB_USER2,
    password: process.env.DB_PASSWORD2,
    database: process.env.DB_NAME2,
    connectionLimit: 5,
    allowPublicKeyRetrieval: true
});

async function query(sql, params) {
    let conn;
    try {
        conn = await pool.getConnection();
        const res = await conn.query(sql, params);
        return res;
    } finally {
        if (conn) conn.end();
    }
}

async function collegeQuery(sql, params) {
    let conn;
    try {
        conn = await collegePool.getConnection();
        const res = await conn.query(sql, params);
        return res;
    } finally {
        if (conn) conn.end();
    }
}


module.exports = { query, collegeQuery };
