<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>VECTOR Institute - Best Embedded Systems Training in Bangalore, Hyderabad, Chennai</title>
    <meta name="description" content="VECTOR Institute – One of the Best Embedded Systems Training Institutes in Hyderabad, Bangalore &amp; Chennai. We offer advanced embedded course with 100% Placement Assistance."/>
    <meta name="keywords" content="Embedded system training, embedded systems training, embedded training institutes, embedded systems training institutes, embedded training, embedded training Banglore, embedded training Hyderabad, embedded training Pune"/>
    <link rel="canonical" href="https://www.vectorindia.org/" />
    <meta property="og:locale" content="en_US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="VECTOR Institute - Best Embedded Systems Training in Bangalore, Hyderabad, Chennai" />
    <meta property="og:description" content="VECTOR Institute – One of the Best Embedded Systems Training Institutes in Hyderabad, Bangalore &amp; Chennai. We offer advanced embedded course with 100% Placement Assistance." />
    <meta property="og:url" content="https://www.vectorindia.org/" />
    <meta property="og:site_name" content="VectorIndia" />
    <meta name="twitter:card" content="summary"/>
    <meta name="twitter:description" content="VECTOR Institute – One of the Best Embedded Systems Training Institutes in Hyderabad, Bangalore &amp; Chennai. We offer advanced embedded course with 100% Placement Assistance."/>
    <meta name="twitter:title" content="VECTOR Institute - Best Embedded Systems Training in Bangalore, Hyderabad, Chennai"/>


    <!-- favicons Icons -->
    <script type = "text/javascript" >
    var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-20295166-1']);
_gaq.push(['_trackPageview']);
(function() {
    var ga = document.createElement('script');
    ga.type = 'text/javascript';
    ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0];
    s.parentNode.insertBefore(ga, s);
})(); </script>

    <!-- Google tag (gtag.js) start--> 
      <script async src="https://www.googletagmanager.com/gtag/js?id=G-VPDCB8JKFY"></script> 
      <script> 
         window.dataLayer = window.dataLayer || []; 
         function gtag(){dataLayer.push(arguments);} 
         gtag('js', new Date()); 
         gtag('config', 'G-VPDCB8JKFY'); 
      </script>
       <!-- Google tag (gtag.js) end-->
    
    <link rel="icon" type="image/png" sizes="32x32" href="/assets/images/favicons/favicon.png" />
    <link rel="icon" type="image/png" sizes="16x16" href="/assets/images/favicons/favicon.png" />
    <meta name="description" content="Vector India" />

    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">


    <link rel="stylesheet" href="/assets/vendors/bootstrap/css/bootstrap.min.css" />
    <link rel="stylesheet" href="/assets/vendors/animate/animate.min.css" />
    <link rel="stylesheet" href="/assets/vendors/animate/custom-animate.css" />
    <link rel="stylesheet" href="/assets/vendors/fontawesome/css/all.min.css" crossorigin />
    <link rel="stylesheet" href="/assets/vendors/jarallax/jarallax.css" />
    <link rel="stylesheet" href="/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css" />
    <link rel="stylesheet" href="/assets/vendors/nouislider/nouislider.min.css" />
    <link rel="stylesheet" href="/assets/vendors/nouislider/nouislider.pips.css" />
    <link rel="stylesheet" href="/assets/vendors/odometer/odometer.min.css" />
    <link rel="stylesheet" href="/assets/vendors/swiper/swiper.min.css" />
    <link rel="stylesheet" href="/assets/vendors/kontin-icons/style.css">
    <link rel="stylesheet" href="/assets/vendors/vector-fonts/vector-fonts.css">
    <link rel="stylesheet" href="/assets/vendors/tiny-slider/tiny-slider.min.css" />
    <link rel="stylesheet" href="/assets/vendors/reey-font/stylesheet.css" />
    <link rel="stylesheet" href="/assets/vendors/owl-carousel/owl.carousel.min.css" />
    <link rel="stylesheet" href="/assets/vendors/owl-carousel/owl.theme.default.min.css" />
    <link rel="stylesheet" href="/assets/vendors/bxslider/jquery.bxslider.css" />
    <link rel="stylesheet" href="/assets/vendors/bootstrap-select/css/bootstrap-select.min.css" />
    <link rel="stylesheet" href="/assets/vendors/vegas/vegas.min.css" />
    <link rel="stylesheet" href="/assets/vendors/jquery-ui/jquery-ui.css" />

    <!-- template styles -->
    <link rel="stylesheet" href="/assets/css/kontin.css" />
    <link rel="stylesheet" href="/assets/css/kontin-responsive.css" />
    <link rel="stylesheet" href="/assets/css/vector-fonts.css" />
    <link rel="stylesheet" href="/assets/css/enquiry-pop.css" />

</head>

<body>
    <div class="preloader">
        <img class="preloader__image" width="60" src="/assets/images/loader.png" alt="VECTOR Institute" />
    </div>

    <div class="bts-popup" role="alert">
    <div class="bts-popup-container">
        <a href="#0" class="bts-popup-close img-replace"></a>
        <div class="contact-form">
          <form class="contact-form" action="" method="POST" id="frmPopEnquiry">
            <strong>Quick Enquiry</strong>
            <div class="popup-form">
              <input type="text" name="name" id="name" placeholder="Full Name" required>
              <input type="email" name="email" id="email" placeholder="Email ID" required>
              <input type="number" name="mobile" id="mobile" placeholder="Mobile number" required>
              <select name="course_interestfor">
                <option value="">Interested For</option>
                <option value="Embedded Systems (Regular)" selected>Embedded Systems (Regular)</option>
                <option value="Embedded Systems (Online)">Embedded Systems (Online)</option>
                <!-- <option value="Full Stack Development">Full Stack Development</option> -->
                <option value="Automotive Embedded">Automotive Embedded</option>
                <option value="Autosar">Autosar</option>
                <option value="Micro Python">Micro Python</option>
                <option value="Python">Python</option>
                <option value="Embedded C">Embedded C</option>
                <option value="IOT and Beyond">IOT and Beyond</option>
                <option value="AI/ML on Embedded Systems">AI/ML on Embedded Systems</option>
                <option value="Make your own Alexa">Make your own Alexa</option>
            </select>
              <textarea rows="4" name="enquiry" placeholder="Enquiry"></textarea>
            </div>
            <button class="theme-btn btn-style-two" type="submit"><span>Submit</span></button>           
          </form>
        </div>
    </div>
</div>

    <!-- /.preloader -->
    <div class="page-wrapper">
        <header class="main-header clearfix">
            <div class="main-header__top">
                <div class="container">
                    <div class="main-header__top-inner clearfix">
                        <div class="main-header__top-left">
                            <ul class="list-unstyled main-header__top-address">
                                <li>
                                    <div class="icon">
                                        <span class="icon-email"></span>
                                    </div>
                                    <div class="text">
                                        <a href="mailto:info@vectorindia.org">info@vectorindia.org</a>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <span class="icon-telephone"></span>
                                    </div>
                                    <div class="text">
                                        <a href="tel:+91 98666 66699">+91 98666 66699</a>
                                    </div>
                                </li>
                                
                            </ul>
                        </div>
                        <div class="main-header__top-right">
                            <div class="main-header__top-right-social">
                                <a href="admissions.html">Admission</a>
                                <a href="student-login.html" target="_blank">Student Login</a>
                                <a href="/registration">Apply Online</a>
                                <a href="" class="bts-popup-trigger">Quick Enquiry</a>
                                <a href="javascript:void(0)" class="search-link search-box-btn"><i class="fa fa-search"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <nav class="main-menu clearfix">
                <div class="main-menu-wrapper clearfix">
                    <div class="container clearfix">
                        <div class="main-menu-wrapper-inner clearfix">
                            <div class="main-menu-wrapper__left clearfix">
                                <div class="main-menu-wrapper__logo">
                                    <a href="/"><img src="/assets/images/resources/logo.png" alt=""></a>
                                </div>
                                <div class="main-menu-wrapper__main-menu">
                                    <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                                    <ul class="main-menu__list">
                                        <li><a href="institute.html">Institute</a></li>
                                        <li class="dropdown">
                                            <a href="#">Embedded Systems</a>
                                            <ul>
                                                <li><a href="embedded-systems.html">Embedded Systems (Regular)</a></li>
                                                <li><a href="online-embedded-systems.html">Embedded Systems (Online)</a></li>
                                            </ul>
                                        </li>
                                        <!-- <li><a href="full-stack-development.html">Full Stack Development</a></li> -->
                                        <li class="dropdown">
                                            <a href="#">Short Term Courses</a>
                                            <ul>
                                                <li><a href="automative-embedded.html">Automotive Embedded</a></li>
                                                <li><a href="autosar.html">Autosar</a></li>
                                                <li><a href="micro-python.html">Micro Python</a></li>
                                                <li><a href="python.html">Python</a></li>
                                                <li><a href="embedded-c.html">Embedded C</a></li>
                                            </ul>
                                        </li>
                                        <li class="dropdown">
                                            <a href="#">Corporates</a>
                                            <ul>
                                                <li><a href="corporate-hiring.html">Hire From Us</a></li>
                                                <li><a href="corporate-training.html">Train From Us</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="workshops.html">Workshops</a></li>
                                        <li><a href="placements.html">Placements</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </header>

        <div class="stricky-header stricked-menu main-menu">
            <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
        </div><!-- /.stricky-header -->

        <!-- Banner One Start -->
        <section class="main-slider">
            <div class="swiper-container thm-swiper__slider" data-swiper-options='{"slidesPerView": 1, "loop": true, 
                "effect": "slideInLeft",
                    "pagination": {
                    "el": "#main-slider-pagination",
                    "type": "bullets",
                    "clickable": true
                },
                    "navigation": {
                    "nextEl": "#main-slider__swiper-button-next",
                    "prevEl": "#main-slider__swiper-button-prev"
                    },
                    "autoplay": {
                    "delay": 5000
                }}'>
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="image-layer"
                            style="background-image: url(/assets/images/slider/slide1.jpg);"></div>
                        <div class="image-layer-overlay"></div>
                        <!-- /.image-layer -->
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-12 col-md-6 col-sm-6">
                                    <div class="main-slider__content">
                                        <!-- <h5>Embedded systems training</h5> -->
                                        <h1>India's Leading<br>Embedded Systems<br>Training Institute</h1>
                                        <p>Making students industry-ready<br>with application-oriented training program!</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="image-layer"
                            style="background-image: url(/assets/images/slider/slide2.jpg);">
                        </div>

                        <div class="image-layer-overlay"></div>
                        <!-- /.image-layer -->
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-12 col-md-6 col-sm-6">
                                    <div class="main-slider__content">
                                        <!-- <h5>Embedded systems training</h5> -->
                                        <h2 style="visibility:hidden;">India's Leading<br>Embedded Systems<br>Training Institute</h2>
                                        <p style="visibility:hidden;">Making students industry-ready<br>with application-oriented training program!</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="main-slider__social-links">
                    <a href="https://www.linkedin.com/company/vectorindia" target="_blank" class="linkedin"><i class="fab fa-linkedin"></i></a>
                    <a href="https://www.facebook.com/VectorInstitute" target="_blank" class="facebook"><i class="fab fa-facebook"></i></a>
                    <a href="https://twitter.com/Vector_India" target="_blank" class="twitter"><i class="fab fa-twitter"></i></a>
                    <a href="http://www.instagram.com/vectorindiainstitute" target="_blank" class="instagram"><i class="fab fa-instagram"></i></a>
                </div>

                <div>
                    <ul id="social-sidebar">
                      <li><a href="https://wa.me/+919866666699" target="_blank" class="whatsapp"><i class="fab fa-whatsapp"></i> <span>whatsapp</span></a></li>
                      <li><a href="" class="bts-popup-trigger wpforms"><i class="fab fa-wpforms"></i> <span>Quick Enquiry</span></a></li>
                    </ul>
                </div>
                <!-- If we need navigation buttons -->
                <div class="swiper-pagination" id="main-slider-pagination"></div>
                <!-- <div class="main-slider__nav">
                    <div class="swiper-button-prev" id="main-slider__swiper-button-next">
                        <i class="icon-right-arrow icon-left-arrow"></i>
                    </div>
                    <div class="swiper-button-next" id="main-slider__swiper-button-prev">
                        <i class="icon-right-arrow"></i>
                    </div>
                </div> -->
            </div>
        </section>
        <!--Banner One End-->
        <!--CTA One Start-->
        <section class="cta-one">
            <div class="cta-one-bg homecta" data-speed="0.2" data-imgPosition="50% 0%"
                style="background-image: url(/assets/images/apply-now-bg.jpg);"></div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="cta-one__inner wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                            <div class="cta-one__title">
                                <h2>Click Here to Apply for Vector Online Scholarship Test</h2>
                            </div>
                            <div class="cta-one__btn-box">
                                <a href="/registration" class="btn-style-one cta-one__btn">
                                    <i class="btn-curve"></i>
                                    <span class="btn-title">Apply Now</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--CTA One End-->

        <!--Welcome One Start-->
        <section class="welcome-one lightgray-bg">
            <div class="container">
                <div class="row">
                    <div class="col-xl-6 col-lg-6 col-sm-6 mobile-order2">
                        <div class="welcome-one__right">
                            <div class="section-title text-left">
                                <h2 class="section-title__title">Unbeatable placement records that most institutes only dream of!</h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 col-sm-6 mobile-order1">
                        <div class="welcome-one__left">
                            <div class="welcome-one__img-box">
                                <div class="welcome-one__img">
                                    <img src="/assets/images/resources/about-image.jpg" alt="Best embedded systems institute in Bangalore">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row margin-top70">
                    <div class="col-xl-5 col-lg-5 col-sm-5">
                        <div class="welcome-one__completed">
                            <div class="welcome-one__completed-text mrgn-lft0">
                                <h6><span class="number-text"><b>MNC's hired in 2021</b></span><span class="odometer">630</span> <span class="number-plus">+</span></h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-sm-4">
                        <div class="welcome-one__completed">
                            <div class="welcome-one__completed-text">
                                <h6><span class="number-text"><b>Offers in 2021</b></span> <span class="odometer">2150</span><span class="number-plus">+</span></h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-sm-3">
                        <div class="welcome-one__completed">
                            <div class="welcome-one__completed-text">
                                <h6><span class="number-text"><b>Number of<br>courses</b></span><span class="odometer">6</span></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Welcome One End-->
        <!--Brand One Start-->
        <section class="home-plcements brand-one lightgray-bg">
            <div class="container">
                <div class="thm-swiper__slider swiper-container" data-swiper-options='{"spaceBetween": 100, "slidesPerView": 3, "autoplay": { "delay": 3000 },
                    "navigation": {
                    "nextEl": "#home-plcements__swiper-button-next",
                    "prevEl": "#home-plcements__swiper-button-prev"
                    },

                    "breakpoints": {
                    "0": {
                        "spaceBetween": 30,
                        "slidesPerView": 1
                    },
                    "375": {
                        "spaceBetween": 30,
                        "slidesPerView": 1
                    },
                    "575": {
                        "spaceBetween": 30,
                        "slidesPerView": 2
                    },
                    "767": {
                        "spaceBetween": 50,
                        "slidesPerView": 2
                    },
                    "991": {
                        "spaceBetween": 50,
                        "slidesPerView": 3
                    },
                    "1199": {
                        "spaceBetween": 20,
                        "slidesPerView": 3
                    }
                }}'>
                    <div class="swiper-wrapper hmslide-recruiting-comp-list hmmain-recruiting-comp">
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/l-and-t.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">404</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/bosch.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">355</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/american-megatrends.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">325</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/valeo.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">306</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/safran.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">302</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/ust-global.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">300</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/zf.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">278</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/capegemini.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">276</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/delphi-technologies.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">272</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/purpletalk.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">185</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/sasken.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">181</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/brigosha.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">179</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/harman.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">170</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/lgsoft.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">157</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/magneti-marelli.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">151</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/vvdn.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">150</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/hyundai-mobis.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">142</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/tech-mahindra.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">138</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/wipro.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">138</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/danlaw.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">123</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/huawei.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">122</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/einfochips.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">117</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/redpine-signals.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">99</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/honeywell.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">95</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/continental-automotive.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">87</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/visteon.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">86</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/cyient.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">81</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/sandisk.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">80</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/tata-elxsi.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">80</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/ncr.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">79</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/hella.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">77</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/collins-aerospace.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">70</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <div class="company-list-block">
                                <div class="counter-one__icon">
                                <img src="/assets/images/companies/siemens.png">
                                </div>
                                <div class="comp-count-txt">
                                    <h3 class="odometer">69</h3>
                                    <p class="counter-one__text">Students Recruited</p>
                                </div>
                            </div>
                        </div><!-- /.swiper-slide -->
                    </div> 
                </div>
                <div class="home-plcements__nav">
                        <div class="swiper-button-prev" id="home-plcements__swiper-button-next"></div>
                        <div class="swiper-button-next" id="home-plcements__swiper-button-prev"></div>
                    </div>

                            <div class="cta-one__btn-box text-center margin-top50">
                                <a href="institute.html" class="btn-style-one cta-one__btn">
                                    <i class="btn-curve"></i>
                                    <span class="btn-title">More about Vector India</span>
                                </a>
                            </div>
            </div>
        </section>
        <!--Brand One End-->

        <!--Services One Start-->
        <section class="services-one services-two course-section courses-we-offer">
            <div class="container">
                <div class="section-title text-center">
                    <h2 class="section-title__title">Courses we offer</h2>
                    <p>Access to long & short term courses we offer to enhance your technical knowledge</p>
                </div>
                <div class="row">
                    <div class="col-xl-6 col-lg-6 wow fadeInLeft" data-wow-duration="1500ms" data-wow-delay="0ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="embedded-systems.html">Embedded systems Development</a>
                                </h3>
                                <p class="services-one__text">Embedded systems are evolving at breakneck speed, driving advances in technology and fuelled by lower costs of implementing hardware and software components.</p>
                                <div class="course-time">
                                    <p>Duration: 6 months<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="/registration">Apply Now</a>
                                <a href="embedded-systems.html">Know More</a>
                                <a href="#">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="automative-embedded.html">Automotive Embedded</a>
                                </h3>
                                <p class="services-one__text">The Automotive industry is one of the major application domains of embedded systems. Automotive embedded systems are the one where electronics take control over the mechanical system.</p>
                                <div class="course-time">
                                    <p>Duration: 6 weeks<br>
                                    Course type: Online</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="Automotive Embedded">Contact Us</a>
                                <a href="automative-embedded.html">Know More</a>
                                <a href="/assets/images/downloads/Automotive-Embedded-Brochure.pdf" target="_blank">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="autosar.html">AUTOSAR</a>
                                </h3>
                                <p class="services-one__text">It pursues the objective to create and establish an open and standardized software architecture for automotive electronic control units.</p>
                                <div class="course-time">
                                    <p>Duration: 6 weeks<br>
                                    Course type: Online</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="AUTOSAR">Contact Us</a>
                                <a href="autosar.html">Know More</a>
                                <a href="/assets/images/downloads/Autosar-Brochure.pdf" target="_blank">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="micro-python.html">Micro Python</a>
                                </h3>
                                <p class="services-one__text">Micro Python is a lean and efficient implementation of the Python 3 programming language that includes a small subset of the Python..</p>
                                <div class="course-time">
                                    <p>Duration: 2 Weeks<br>
                                    Course type: Online</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="Micro Python">Contact Us</a>
                                <a href="micro-python.html">Know More</a>
                                <a href="/assets/images/downloads/Micropython-Brochure.pdf" target="_blank">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="embedded-c.html">Embedded C</a>
                                </h3>
                                <p class="services-one__text">Embedded C is a set of language extensions for the C programming language by the C Standards Committee to address commonality issues that exist between C extensions..</p>
                                <div class="course-time">
                                    <p>Duration: 6 Weeks<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="Embedded C">Contact Us</a>
                                <a href="embedded-c.html">Know More</a>
                                <a href="#">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <!-- <div class="col-xl-6 col-lg-6 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="full-stack-development.html">Full Stack Development</a>
                                </h3>
                                <p class="services-one__text">A comprehensive Full Stack Development Course ( MERN stack ) with theoretical & practical hands-on coding experience.</p>
                                <div class="course-time">
                                    <p>Duration: 4 Months<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="Full Stack Development">Contact Us</a>
                                <a href="full-stack-development.html">Know More</a>
                                <a href="#">Brochure</a>
                            </div>
                        </div>
                    </div> -->
                    <div class="col-xl-6 col-lg-6 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="python.html">Python</a>
                                </h3>
                                <p class="services-one__text">Our Python certification course will give you hands-on development experience and prepare you for an exciting career as a professional Python programmer.</p>
                                <div class="course-time">
                                    <p>Duration: 4 weeks<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="Python">Contact Us</a>
                                <a href="python.html">Know More</a>
                                <a href="/assets/images/downloads/Python-Brochure.pdf" target="_blank">Brochure</a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div class="cta-one__btn-box text-center margin-top50">
                    <a href="#" class="btn-style-one cta-one__btn">
                        <i class="btn-curve"></i>
                        <span class="btn-title">View All Courses</span>
                    </a>
                </div> -->
            </div>
        </section>

        <!--We Building Two Start-->
        <section class="we-building-two">
            <div class="we-building-two-bg" data-jarallax data-speed="0.2" data-imgPosition="50% 0%"
                style="background-image: url(/assets/images/backgrounds/video-bg.jpg)"></div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="we-building-two__inner">
                            <div class="we-building__video-link">
                                <a href="https://www.youtube.com/watch?v=Oitl6hda_S0" class="video-popup">
                                    <div class="we-building__video-icon">
                                        <span class="icon-play-button"></span>
                                        <i class="ripple"></i>
                                    </div>
                                </a>
                            </div>
                            <h2 class="we-building__video-title">Events @ Vector India</h2>
                            <p class="we-building__video-paragraph">Women's Day celebration</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--We Building Two End-->
        <!--Brand One Start-->
        <section class="brand-one brand-two companies-bg">
            <div class="container">
                <div class="section-title text-center">
                    <h2 class="section-title__title">Other Prestigious Companies</h2>
                </div>
                <div class="thm-swiper__slider swiper-container" data-swiper-options='{"spaceBetween": 20, "slidesPerView": 5, "autoplay": { "delay": 5000 },
                    "navigation": {
                    "nextEl": "#brand-plcements__swiper-button-next",
                    "prevEl": "#brand-plcements__swiper-button-prev"
                    },
                    "breakpoints": {
                    "0": {
                        "spaceBetween": 30,
                        "slidesPerView": 2
                    },
                    "375": {
                        "spaceBetween": 30,
                        "slidesPerView": 2
                    },
                    "575": {
                        "spaceBetween": 30,
                        "slidesPerView": 3
                    },
                    "767": {
                        "spaceBetween": 30,
                        "slidesPerView": 4
                    },
                    "991": {
                        "spaceBetween": 20,
                        "slidesPerView": 5
                    },
                    "1199": {
                        "spaceBetween": 20,
                        "slidesPerView": 5
                    }
                }}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company1.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company2.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company3.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company4.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company5.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company6.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                        <div class="swiper-slide">
                            <img src="/assets/images/companies/company7.jpg" alt="">
                        </div><!-- /.swiper-slide -->
                    </div>
                </div>
                <div class="brand-plcements__nav">
                    <div class="swiper-button-prev" id="brand-plcements__swiper-button-next"></div>
                    <div class="swiper-button-next" id="brand-plcements__swiper-button-prev"></div>
                </div>
            </div>
        </section>
        <!--Brand One End-->
        <!--Services One Start-->
        <section class="services-one services-two course-section workshops-section">
            <div class="container">
                <div class="section-title text-center">
                    <h2 class="section-title__title">Workshops we offer</h2>
                    <p>Organizing a workshop can be an exciting way to strengthen your relationship with current clients,<br>establish new relationships and further develop yourself in your area of business.</p>
                </div>
                <div class="row">
                    <div class="col-xl-4 col-lg-4 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="iot-and-beyond.html">IOT and Beyond</a>
                                </h3>
                                <p class="services-one__text">IOT and beyond focuses on this digital revolution that engaging in digital technology and investment.</p>
                                <div class="course-time">
                                    <p>Duration: 18 Hours<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="IOT and Beyond">Contact Us</a>
                                <a href="iot-and-beyond.html">Know More</a>
                                <a href="#">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="machine-learning-on-embedded-systems.html">AI/ML on Embedded Systems</a>
                                </h3>
                                <p class="services-one__text">With embedded AI /ML devices have the ability to run AI/ML models at the device level and then directly use the results to perform an appropriate task or action.</p>
                                <div class="course-time">
                                    <p>Duration: 17 Hours<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="AI/ML on Embedded Systems">Contact Us</a>
                                <a href="machine-learning-on-embedded-systems.html">Know More</a>
                                <a href="#">Brochure</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <div class="services-one__icon">
                                    <span class="icon-embedded"></span>
                                </div>
                            <div class="services-one__content">
                                <h3 class="services-one__title"><a href="make-your-own-alexa.html">Make your own Alexa</a>
                                </h3>
                                <p class="services-one__text">Not everyone can afford that amount of money just for a speaker. There is one thing you can do; You can build your own Alexa for free</p>
                                <div class="course-time">
                                    <p>Duration: 8 Hours<br>
                                    Course type: Online / Offline</p>
                                </div>
                            </div>
                            <div class="courses-button-links">
                                <a href="" class="bts-popup-trigger" data-interested="Make your own Alexa">Contact Us</a>
                                <a href="make-your-own-alexa.html">Know More</a>
                                <a href="#">Brochure</a>
                            </div>
                        </div>
                    </div>
                    

                </div>
                <div class="cta-one__btn-box text-center margin-top50">
                                <a href="workshops.html" class="btn-style-one cta-one__btn">
                                    <i class="btn-curve"></i>
                                    <span class="btn-title">View All Workshops</span>
                                </a>
                            </div>
            </div>

        </section>

        

        

        <!--Projects One Start-->
        <section class="project-two project-page lightgray-bg2">
            <div class="container">
                <div class="section-title text-center">
                    <h2 class="section-title__title">@vectorindiainstitute</h2>
                </div>
                <div class="row" id="instafeed">
                    <!-- Instagram feed -->
                </div>
            </div>
        </section>
        <!--Projects One End-->

        <!--Testimonial One Start-->
        <section class="testimonial-one white-background">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="testimonial-one__right">
                            <div class="section-title text-center">
                                <h2 class="section-title__title">Testimonials</h2>
                            </div>
                            <div class="testimonial-one__carousel owl-theme owl-carousel">
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/janani-v.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">I joined Vector as a batch 7 student. I Got placed in Continental - 6LPA and Tejas Networks – 10LPA through Vector and I Decided to choose Tejas Networks. I Thank each and every one who helped me to get into my path Vector has given me such a wonderful opportunity to start my carrier in Networking Field.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Janani V</h5>
                                        <h6 class="testimonial-one__client-title">V21BE7J3 | Tejas Networks | 10 LPA</h6>
                                    </div>
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/kr-ranjith.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">My friends and family suggest me to join in the vector India. Then I enquired vector India and I am very successful with their approach and their teaching skills.I got Placed in three companies Vitesco, Global logic, andTosall. and my pleasure to be one of the members of Vitesco. I selected Vitesco.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">K. R Ranjith</h5>
                                        <h6 class="testimonial-one__client-title">V21CE6R2 | Vitesco | 6 LPA</h6>
                                    </div>
                                </div>

                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/vishal-kishor-thigle.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">I am Vishal Kishor Thigle and I completed my engineering from RajarshiShahu college of engineering, Buldana. Basically, I am from Maharashtra. I would like to share my experience with Vector where I got placed in Accord Global. Actually, I didn’t know about the Vector but my friend told me about the vector. He told me that Vector is one of the best institutes for the embedded systems. Then I joined the Vector and I started my training and I learned many things in the Vector not only embedded systems but also communication also. As per my experience vector is best institute. All the staff, Lab coordinators all are fully experience persons. Thanks!!</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Vishal Kishor Thigle</h5>
                                        <h6 class="testimonial-one__client-title">V21HE5V5 | Accord Global | 3.6 LPA</h6>
                                    </div>
                                </div>

                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/mahammed-ozair-gandhi.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">I am Mahammed Ozair Gandhi. My ID is V20HE10G8. Thanks to Vector India because they provided me with excellent knowledge in C, C++ and Data Structures. There were very helpful and intelligent faculties. I worked very hard till 6 month then I got placed in 3 companies together with the package of 5 LPA, 5.5 LPA, 14.25 LPA. I choose SAMSUNG with 14.25LPA package. Thanks to My parents for their support and Specially thanks for Joshi sir (PLACEMENT OFFICER) for their helpful advices and support.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Mahammed Ozair Gandhi</h5>
                                        <h6 class="testimonial-one__client-title">V20HE10G8 | SAMSUNG | 14.25 LPA</h6>
                                    </div>
                                    
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/yograjsingh-mandloi.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">Hello Guys... I am Yograj Singh Mandloi from V21HE1 batch, recently I got placed in Robert Bosch. First of all thank you so much to vector India for giving me the opportunity to myself as well as for teaching in depth theoretically and practicality each module. I proud to be a part of vector India Hyderabad. Very supporting staff. and placement assistance is too good. So do hard work and get success. And best of luck to my friends....and also CONGRATULATION those who got selected in Recent Company as well. Once again thank you so much vector India and Hyderabad vector Team. Thank you!</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Yograjsingh Mandloi</h5>
                                        <h6 class="testimonial-one__client-title">V21HE1 | ROBERT BOSCH | 5 LPA</h6>
                                    </div>
                                    
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/abhishek-gajanan-kulkarni.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">Hello everyone, my name is Abhishek Kulkarni and I am the student of V21BE1 Batch. Currently I am working as Associate Software Developer at BorgWarner (Previously Delphi Technologies). Vector Institute is one of the mile stone. The embedded system course here is one of the best industry specific course I have ever seen. The overall syllabus, the path vector chosen to teach the students, the methodology of teaching from scratch to expert is awesome. You might have gone through lot of advertisements assuring for placements. But I would like to tell you, vector is like second home for all the career oriented people. The teaching staff, placement team, overall guidance, support and very much important is one to many interaction here is amazing. Before vector, I was confused about my life, I was having question mark all the time when I would think about my career. But training over here changed my thinking aspects, my life and my future. Thank you very much Vector Institute, thank you for all and for the guidance which help me a lot to build my career.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Abhishek Gajanan Kulkarni</h5>
                                        <h6 class="testimonial-one__client-title">V21BE1A13 | Delphi Technologies| 3 LPA</h6>
                                    </div>
                                    
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/ragini-alkari.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">Doing the Vector course is the best decision of mine. Vector Institute is the best place to learn. They Teach everything from scratch, helps everyone in understanding concepts. All The Faculties are best in their subjects and are very much supportive. They Provide Best Placement Assistance and helps you to get your dream Job. I would like to thank all the faculty members, Placement Team and all the support staff for their continuous support. So, if you want to get your dream job in embedded industries Vector is the best place to be at.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Ragini Alkari</h5>
                                        <h6 class="testimonial-one__client-title">V20BE9R6 | Harman International | 5 LPA</h6>
                                    </div>
                                    
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/amulya-raj-k-n.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">Vector India is THE MOST AMAZING INSTITUTION that actually helps u prepare for the future. It is the one of the kind institutions where you have AMAZING FACULTY and INSTRUCTOR that help us understand and learn concepts rather than just read them. I have to thank my family for putting me in this institution and within just 6 months I got placed in one the largest Automobile company called APTIV. I am thankful to all the teachers and my friends at vector for their help. Thank you once again VECTOR for my amazing career startup.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Amulya Raj K.N</h5>
                                        <h6 class="testimonial-one__client-title">V20BE9A11 | Aptiv | 5.5 LPA</h6>
                                    </div>
                                    
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/aditya-hareshbhai-viradiya.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">Hello everyone, my self-Aditya viradiya from Gujarat. I am from V20BE10 Bangalore Batch, and i am very thankful to all faculties & Placement cell. now i am placed in LEAR CORPORATION, PUNE. my batch are totally goes on hybrid mode so, i learn all modules at home by own practicing, all faculties guidance and vector are fully support to grow me. Basically, i was studied 1 to 12th in Gujarati language   so, my communication skills in English are moderate but, if you practicing and focus on all technical modules then interviewer cannot ignore you based on your communication skills. In vector all modules are very important to get decent job role. So, prepare well doing best & give best and stay cool minded and confident while attending interview rounds. I hope everyone will placed in their dream job and one thing is not go for higher packages. Only placement is important now and if you have potential then your salary increase automatically.  Thank you vector for make my future bright.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Aditya Hareshbhai Viradiya</h5>
                                        <h6 class="testimonial-one__client-title">V20BE10V1 | Lear Corp | 5 LPA</h6>
                                    </div>
                                    
                                </div>
                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/saibi-shaik.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">After completion of my graduation, I joined in Vector and with half knowledge of coding skills, at that time I am unable to pickup the coding classes and it took more time for me to gain the knowledge after that I picked up the coding with the help of the staff and LC’s in the training institute and I got placed in good company with good package. It is good experience for me to join Vector and learned lot of technical things. Thank you, Vector India.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Dhanasaibi Shaik</h5>
                                        <h6 class="testimonial-one__client-title">V19HE1S17 | ALTRAN | 4.5 LPA</h6>
                                    </div>
                                    
                                </div>

                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/Ankit-Pathak.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">I Am Ankith Pathak who joined Vector in Dec 2021 with a very high hope that one day I will also get placed in a good company. When i joined Vector i was very happy because we got a chance to learn or get concepts of C by Guru Sir, the way he explains the concepts it was great. After C we started learning concepts of C++ by Siddiq Sir, the way of explanation was awesome and was very easy to understand, Each and every concept which they explained i am assure this will always be with me and helps me in future as well. After C++ the most important concept of 8051 (Embedded C) was given by Pramod Sir, the way he explains I became Fan of his teaching style and Vector is a best Institute of India for Embedded Training. The main Factor which helped me a lot was timely schedule test to optimize my learning, I am Thankful to my placement team headed by Joshi Sir who put their efforts day and night to bring the companies which can change your life, the motivation which Joshi sir provides is exceptional. It worked as a guidance to achieve what we wish for. Even if you fail multiple times then also, they will be pushing you by providing more opportunities and guidance till you finally achieve your goal. Finally, I want to say that I am very much thankful to whole team of Vector India,Bangalore which helped me in getting hired in one of my dream company MERCEDES BENZ ResearchandDevelopment India as Graduate Engineer Trainee. That was all my experience in Vector. Hope Vector InstituteWill Keep changing students life like Mine. </p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Ankit Pathak</h5>
                                        <h6 class="testimonial-one__client-title">V21BE6A14 | Mercedes Benz | 10 LPA</h6>
                                    </div>
                                </div>

                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/Pratiksha-Chandrakant-More.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">I am forever grateful to all the faculties and placement cell for giving me this opportunity and supporting me. I got placed in MERCEDES BENZ I joined Vector in Dec 2021, it was a 6months course, here i learnt C, C++, Embedded C Modules which are applied in Industries. Vector provides us good practical knowledge as per Industry requirements and they give us a chance to attend very good companies.
                                    Everyone who joins Vector will get a very good career opportunities, so my suggestion to everyone is to join Vector Institute,all staff members Guru Sir, Siddiq Sir, Pramod Sir, Pavan Sir all are more supportive as well as Habeeba Mam and Joshi Sir from Placement Cell are also supportive and with their guidance Finally, I got placed in a Good MNC Mercedes Benz.</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Pratiksha Chandrakant More</h5>
                                        <h6 class="testimonial-one__client-title">V21BE6P2 | Mercedes Benz | 10 LPA</h6>
                                    </div>
                                </div>

                                <!--Testimonial One Single-->
                                <div class="testimonial-one__single">
                                    <div class="testimonial-one__client-img">
                                        <img src="/assets/images/testimonial/ujwal vijayrao talkit.jpg" alt="">
                                    </div>
                                    <p class="testimonial-one__text">I am UJWAL VIJAYRAO TALKIT, Recently I got placed in Mercedes Benz (R& D India) Through Vector. I am very thankful to Vector for giving me this Golden Opportunity, I got placed in two companies Continental with a package of 6LPA and Mercedes Benz with a package of 10LPA, I Joined one of my dream company Mercedes Benz</p>
                                    <div class="testimonial-one__client-info">
                                        <h5 class="testimonial-one__client-name">Ujwal Vijayrao Talkit V</h5>
                                        <h6 class="testimonial-one__client-title">V21BE6U1 | Mercedes Benz | 10 LPA</h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Testimonial One End-->

        <!--Have Questions Start-->
        <section class="have-questions lightgray-bg2">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8 col-lg-8">
                        <div class="have-questions__left">
                            <div class="section-title text-center">
                                <h2 class="section-title__title">Have Any Questions?</h2>
                            </div>
                        </div>
                        <div class="have-questions__right">
                            <div class="accrodion-grp" data-grp-name="faq-one-accrodion">
                                <div class="accrodion">
                                    <div class="accrodion-title">
                                        <h4>1. What are the courses offered at Vector India?</h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner faq-block">
                                            <p>Vector India offers both long term and short-term courses.</p>
                                            <p class="course-duration"><strong>Course:</strong> Embedded Systems<br>
                                                <strong>Duration:</strong> 6 Months<br>
                                            Admission through Online Entrance Test</p>

                                            <h5>Short Term Courses:</h5>
                                            <table class="table table-striped table-responsive table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td><strong>Automotive Embedded</strong><br /> Duration: 72 Hours<br /> Direct Admission</td>
                                                        <td><strong>AUTOSAR</strong><br /> Duration: 72 Hours<br /> Direct Admission</td>
                                                        <td><strong>Micro Python</strong><br /> Duration: 2 Weeks<br /> Direct Admission</td>
                                                    </tr>
                                                    <tr>
                                                        <td><strong>Embedded C</strong><br /> Duration: 6 Weeks<br /> Direct Admission</td>
                                                        <td><strong>Python</strong><br /> Duration: 30 Days<br /> Direct Admission</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div><!-- /.inner -->
                                    </div>
                                </div>
                                <div class="accrodion">
                                    <div class="accrodion-title">
                                        <h4>2. What is Embedded Systems? Where is it Used?</h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner">
                                            <p>Embedded systems are self-contained programs that are embedded within a piece of hardware. We can say it’s a specialized computer system that is part of a larger system or machine. Typically, an embedded system is housed on a single microprocessor board with the programs stored in ROM. Embedded system can also be defined as a computer system that is created with optimal efficiency, thereby allowing it to complete specific functions as quickly as possible. Embedded systems microprocessors are programmed to automate certain tasks. Cell phones, computers, copiers, medical equipment, programmable logic controllers, and numerous other products rely on embedded systems. Real time embedded systems can be used to replace traditional software applications.</p>

                                            <p>Embedded systems are used in any application or which requires certain level of automation or intelligence. As more and more intelligent devices make their way into our lives, the demand for embedded telecom will increase. In addition, even in areas where telecom companies are in the grips of a slowdown, companies are not making cuts in introducing new features.</p>

                                            <p>The range is really very wide, limited only by human imagination,” B J Ram Rao, CEO, eSmartNet (a division of Zicom Electronic Security Systems) admitted in a recent interview with Zee India. “I would think that, broadly, the embedded system application areas would be wireless, Internet and mobile communications, industrial control, test and measurement, networking, aerospace and automotive control, consumer electronics, digital imaging and defence.”</p>
                                        </div><!-- /.inner -->
                                    </div>
                                </div>
                                <div class="accrodion">
                                    <div class="accrodion-title">
                                        <h4>3. What is the Scope of Embedded Systems?</h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner faq-block">
                                            <p>Embedded System is the future. Every industry needs some artificial intelligence into it and artificial intelligence can be given by embedded systems only. No electronic product is without embedded systems in the market.</p>
                                            <h5>Embedded System Market Size Global forecast to 2025</h5>
                                            <p>The embedded system market is estimated to reach from $86.5 billion in 2020 to $116.2<br>
                                            Billion by 2025, at a CAGR of 6.1% from 2020 to 2025.</p>
                                            <!-- <h5>IDC report</h5>
                                            <p>According to an IDC report the international market as a whole expects product development worth $75 billion, which will require as many as 5,00,000 trained professionals in embedded systems development by the year 2005. While India is a known player in the software services space, the image of the country has been so far as a low-cost service provider. This is where embedded software development, which requires specialized skill sets, can make the difference. Not surprisingly, companies like Wipro, Sasken, Texas Instruments, L&T, Infosys, Siemens, Honeywell, Motorola, Agilent, Patni etc. are all getting into the race. It is a sector promising a fast-track career, which is only for the brightest and the best.</p>
                                            <p>The global embedded and telecom market today is worth one trillion dollars (Source: Gartner).</p> -->

                                            <p>The increase in the number of research and development activities related to embedded systems, rise in demand for advanced driver-assistance systems (ADAS) and electromobility solutions for electric vehicles and hybrid vehicles, increase in demand for portable devices such as wearables, and rise in the use of multicore processors in military applications are making embedded systems one of the most sought-after fields in the market.</p>
                                            <p><strong>2020 – 86.5 billion USD 2025 – 116.2 billion USD (Global Embedded systems market growth).</strong></p>
                                        </div><!-- /.inner -->
                                    </div>
                                </div>
                                <div class="accrodion last-chiled">
                                    <div class="accrodion-title">
                                        <h4>4.  Why VECTOR Institute for Embedded Systems & VLSI Training? </h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner faq-block">
                                            <p>We teach basics and underlying concepts of Embedded Systems in detail, and provide real-time experience to students. This will help each student to not only understand the concept, but also the knowledge of applying concepts in real time situation. Our Embedded Systems & VLSI courses provide complete practical knowledge to students, and makes students ready for placement with Embedded and VLSI industry.</p>

                                            <p>To make the Embedded Systems course full-fledged and complete we have included modules like Object Oriented Concepts with C++, RT-Linux with porting on ARM, 4 mini projects and one major project We cover the Micro controllers in great depth: Intel 8051 and ARM 9 series. In addition, we go for the hardware interfacing in detail. To meet the latest industry requirements, we have included in the course content ARM microcontrollers, Version control tools, and GSM.</p>

                                            <p>Our continuous liaison with Embedded industry has enabled us to know their expectations of each candidate. So, our highly experienced faculties have made sure that our students come out as industry ready professionals.</p>

                                            <p>We have dedicated placement cell to take care of the placements and to make sure that the students are placed at the best possible places. We have ever improved placement record of 630+ campus drives & 2150+ Selects during the year 2021.</p>
                                        </div><!-- /.inner -->
                                    </div>
                                </div>
                                <div class="accrodion last-chiled">
                                    <div class="accrodion-title">
                                        <h4>5.  Admission process followed at VECTOR INSTITUTE for training into long term courses?</h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner faq-block">
                                            <p>The admission into Embedded Systems course is based on our Vector <strong>Online Entrance examination</strong>. *Working professionals with Relevant Experience are eligible for Direct Admission.</p>
                                        </div><!-- /.inner -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="cta-one__btn-box text-center margin-top50">
                    <a href="product-faqs.html" class="btn-style-one cta-one__btn">
                        <i class="btn-curve"></i>
                        <span class="btn-title">View More</span>
                    </a>
                </div>
            </div>
        </section>
        <!--Have Questions End-->

        <!--News One Start-->
        <section class="news-one">
            <div class="container">
                <div class="section-title text-left text-center">
                    <h2 class="section-title__title">Our Blog</h2>
                </div>
                <div class="row">
                    <div class="blog__carousel owl-theme owl-carousel">
                    <div class="col-xl-12 col-lg-12 wow fadeInLeft" data-wow-duration="1500ms" data-wow-delay="0ms">
                        <!--News One Single-->
                        <div class="news-one__single">
                            <div class="news-one__img-box">
                                <div class="news-one__img">
                                    <img src="/assets/images/blog/blog1.png" alt="">
                                    <a href="blog/building-an-embedded-ui-factors-and-design-considerations.html">
                                        <span class="news-one__plus"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="news-one__content">
                                <h3 class="news-one__title">
                                    <a href="blog/building-an-embedded-ui-factors-and-design-considerations.html">Building an Embedded UI: Factors and Design Considerations</a>
                                </h3>
                                <p class="news-one__text">Recent trends show that modern-day users do not want to know how a device works but they just want to utilize it with the shortest learning possible.</p>
                                <div class="news-one__date">
                                    <p>26, Nov 2021</p>
                                </div>
                                <ul class="list-unstyled news-one__meta">
                                    <li><a href="#"><i class="far fa-thumbs-up"></i></a></li>
                                    <li><a href="#"><i class="far fa-comment-alt"></i></a></li>
                                    <li><a href="#"><i class="fa fa-share-alt"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                        <!--News One Single-->
                        <div class="news-one__single">
                            <div class="news-one__img-box">
                                <div class="news-one__img">
                                    <img src="/assets/images/blog/blog2.jpg" alt="">
                                    <a href="blog/attrition-on-rise.html">
                                        <span class="news-one__plus"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="news-one__content">
                                
                                <h3 class="news-one__title">
                                    <a href="blog/attrition-on-rise.html">Attrition on rise</a>
                                </h3>
                                <p class="news-one__text">The attrition rate of leading firms in India is now at an all-time high and companies are facing issues in executing large projects.</p>
                                <div class="news-one__date">
                                    <p>30, Oct 2021</p>
                                </div>
                                <ul class="list-unstyled news-one__meta">
                                    <li><a href="#"><i class="far fa-thumbs-up"></i></a></li>
                                    <li><a href="#"><i class="far fa-comment-alt"></i></a></li>
                                    <li><a href="#"><i class="fa fa-share-alt"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 wow fadeInRight" data-wow-duration="1500ms" data-wow-delay="200ms">
                        <!--News One Single-->
                        <div class="news-one__single">
                            <div class="news-one__img-box">
                                <div class="news-one__img">
                                    <img src="/assets/images/blog/blog3.jpg" alt="">
                                    <a href="blog/adoption-of-security-by-design-for-iot-devices-how-to.html">
                                        <span class="news-one__plus"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="news-one__content">
                                
                                <h3 class="news-one__title">
                                    <a href="blog/adoption-of-security-by-design-for-iot-devices-how-to.html">Adoption of Security by Design for IoT Devices: How to</a>
                                </h3>
                                <p class="news-one__text">It is quite evident that rapid increase in billions of IoT devices has already created a weak spot in the ecosystem due to lack of security.</p>
                                <div class="news-one__date">
                                    <p>3, Sept 2021</p>
                                </div>
                                <ul class="list-unstyled news-one__meta">
                                    <li><a href="#"><i class="far fa-thumbs-up"></i></a></li>
                                    <li><a href="#"><i class="far fa-comment-alt"></i></a></li>
                                    <li><a href="#"><i class="fa fa-share-alt"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 wow fadeInRight" data-wow-duration="1500ms" data-wow-delay="200ms">
                        <!--News One Single-->
                        <div class="news-one__single">
                            <div class="news-one__img-box">
                                <div class="news-one__img">
                                    <img src="/assets/images/blog/blog4.png" alt="">
                                    <a href="blog/the-role-of-embedded-systems-during-covid-19.html">
                                        <span class="news-one__plus"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="news-one__content">
                                
                                <h3 class="news-one__title">
                                    <a href="blog/the-role-of-embedded-systems-during-covid-19.html">The role of Embedded Systems during COVID-19</a>
                                </h3>
                                <p class="news-one__text">COVID-19 left us vulnerable to unprepared dangers that we have never encountered before. Due to its high transmissibility and the lack..</p>
                                <div class="news-one__date">
                                    <p>26, May 2021</p>
                                </div>
                                <ul class="list-unstyled news-one__meta">
                                    <li><a href="#"><i class="far fa-thumbs-up"></i></a></li>
                                    <li><a href="#"><i class="far fa-comment-alt"></i></a></li>
                                    <li><a href="#"><i class="fa fa-share-alt"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        </section>
        <!--News One End-->

        <!--Have Questions Start-->
        <section class="homepagequestions have-questions about-page-have-questions border-top">
            <div class="container">
                <div class="row">
                    <div class="col-xl-4 col-lg-4">
                        <div class="thre-blk-sec1">
                            <div class="have-questions__img">
                                <img src="/assets/images/image2a.jpg" alt="">
                            </div>
                            <h3 class="service-details__title">Why Join Vector India?</h3>
                            <p class="service-details__text">Aspirants, who are willing to shape their career as an expert in Embedded Systems and VLSI can come to our institute and get the benefits of our training courses. We provide best in-class training courses that would reform your concept regarding the subject matter.</p>
                                    <div class="cta-one__btn-box margin-top10">
                                <a href="why-join-vector-india.html" class="btn-style-one cta-one__btn">
                                    <i class="btn-curve"></i>
                                    <span class="btn-title">Learn More</span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4">
                        <div class="thre-blk-sec2">
                            <form>
                            <div class="subscribe-text-block justify-content-center text-center">
                                <i class="fa fa-envelope"></i>
                                <h3 class="">Quick Enquiry</h3>
                                <h5 class="">Know more about courses & placements</h5>
                                <!-- <p class="">Join our subscription list for monthly updates of Vector India.</p> -->
                                <div class="enquiry-fields">
                                    <input type="text" placeholder="Your Name" class="bts-popup-trigger">
                                    <input type="text" placeholder="Mobile Number" class="bts-popup-trigger">
                                    <select name="course_interestfor"  class="bts-popup-trigger">
                                        <option value="">Interested For</option>
                                        <option value="Embedded Systems (Regular)">Embedded Systems (Regular)</option>
                                        <option value="Embedded Systems (Online)">Embedded Systems (Online)</option>
                                        <!-- <option value="Full Stack Development">Full Stack Development</option> -->
                                        <option value="Automotive Embedded">Automotive Embedded</option>
                                        <option value="Autosar">Autosar</option>
                                        <option value="Micro Python">Micro Python</option>
                                        <option value="Python">Python</option>
                                        <option value="Embedded C">Embedded C</option>
                                    </select>
                                    <input type="email" placeholder="Email address" class="bts-popup-trigger">
                                    <textarea rows="2" placeholder="Enquiry" class="bts-popup-trigger"></textarea>
                                </div>
                            </div>
                            <div class="cta-one__btn-box margin-top20 text-center">
                                <button type="submit" class="btn-style-one cta-one__btn bts-popup-trigger">
                                    <i class="btn-curve"></i>
                                    <span class="btn-title">Submit</span>
                                </button>
                            </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4">
                        <div class="thre-blk-sec3">
                            <div class="short-links-info">
                                <h3 class=""><i class="icon-link"></i> Additional Downloads</h3>
                                <ul class="list-unstyled">
                                    <li><a href="/assets/images/downloads/Embedded-Systems-Admission-Form.pdf" target="_blank">Admission Form for Embedded Systems</a></li>
                                    <li><a href="/assets/images/downloads/vector-india-brochure.pdf" target="_blank">Embedded System Brochure</a></li>
                                    <li><a href="/assets/images/downloads/embedded-sampe-test-paper.pdf" target="_blank">Embedded System Sample Paper</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Have Questions End-->

        <footer class="site-footer">
            <div class="site-footer__top">
                <div class="container">
                    <div class="site-footer__top-inner">
                        <div class="site-footer-map"
                            style="background-image: url(/assets/images/shapes/site-footer-mape.png)"></div>
                        <div class="row">
                            <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                                <div class="footer-widget__column footer-widget__about">
                                    <h3 class="footer-widget__title">Hyderabad</h3>
                                    <ul class="list-unstyled footer-widget__contact-list footer-contact-list">
                                        <li>
                                            <div class="text">
                                                <p>#502, Nagasuri Plaza (Bank Of India building), Behind Maithrivanam, Ameerpet, Hyderabad - 500038.</p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="icon-telephone"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="tel:+91 98666 66699">+91 98666 66699</a></p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="fa fa-headphones"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="tel:040 23 73 6669">040 23 73 6669</a></p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="icon-email"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="mailto:info@vectorindia.org">info@vectorindia.org</a></p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                                <div class="footer-widget__column footer-widget__about">
                                    <h3 class="footer-widget__title">Bangalore</h3>
                                    <ul class="list-unstyled footer-widget__contact-list footer-contact-list">
                                        <li>
                                            <div class="text">
                                                <p>33/49, 27th Cross, 12th Main, Jayanagar 4th block, Bangalore - 560011.</p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="icon-telephone"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="tel:+91 87624 56789">+91 87624 56789</a></p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="fa fa-headphones"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="tel:080 26546474">080 26546474</a></p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="icon-email"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="mailto:info.blr@vectorindia.org">info.blr@vectorindia.org</a></p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                                <div class="footer-widget__column footer-widget__about">
                                    <h3 class="footer-widget__title">Chennai</h3>
                                    <ul class="list-unstyled footer-widget__contact-list footer-contact-list">
                                        <li>
                                            <div class="text">
                                                <p>2nd floor, 179, 1st Main Road, Nehru Nagar, Lane Opp to Turyaa Hotel, Perungudi, Chennai - 600096.</p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="icon-telephone"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="tel:+91 94442 22459">+91 94442 22459</a></p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="fa fa-headphones"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="tel:044 24543969">044 24543969</a></p>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="icon">
                                                <span class="icon-email"></span>
                                            </div>
                                            <div class="text">
                                                <p><a href="mailto:info.chen@vectorindia.org">info.chen@vectorindia.org</a></p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                                <div class="footer-widget__column footer-widget__links clearfix">
                                    <h3 class="footer-widget__title">Company</h3>
                                    <ul class="footer-widget__links-list list-unstyled">
                                        <li><a href="institute.html">About Vector India</a></li>
                                        <li><a href="careers.html">Careers</a></li>
                                        <li><a href="alumni.html">Testimonials</a></li>
                                        <li><a href="photogallery.html">Photo Gallery</a></li>
                                        <li><a href="faqs.html">FAQ's</a></li>
                                        <li><a href="policies.html">Policies</a></li>
                                        <li><a href="blog.html">Blog</a></li>
                                        <li><a href="contact-us.html">Contact Us</a></li>
                                        <li><a href="sitemap.html">Site Map</a></li>
                                    </ul>
                                </div>
                            </div>                          
                        </div>
                    </div>
                </div>
            </div>
            <div class="site-footer__bottom">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-8 col-sm-8">
                            <div class="site-footer__bottom-inner">
                                <p class="site-footer__bottom-text">@ Copyrights 2022 by Vector India</p>
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-4">
                            <div class="footer-widget__about-social">
                                <a href="https://www.linkedin.com/company/vectorindia" target="_blank" class="linkedin"><i class="fab fa-linkedin"></i></a>
                                <a href="https://www.facebook.com/VectorInstitute" target="_blank" class="facebook"><i class="fab fa-facebook"></i></a>
                                <a href="https://twitter.com/Vector_India" target="_blank" class="twitter"><i class="fab fa-twitter"></i></a>
                                <a href="http://www.instagram.com/vectorindiainstitute" target="_blank" class="instagram"><i class="fab fa-instagram"></i></a>
                                <a href="https://wa.me/+919866666699" target="_blank" class="whatsapp"><i class="fab fa-whatsapp"></i></a>
                                <a href="" class="enq-form bts-popup-trigger" title="Quick Enquiry"><i class="fab fa-wpforms"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <!--Site Footer One End-->


    </div><!-- /.page-wrapper -->


    <div class="mobile-nav__wrapper">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <!-- /.mobile-nav__overlay -->
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

            <div class="logo-box">
                <a href="/" aria-label="logo image"><img src="/assets/images/footer-logo.png" width="155"
                        alt="" /></a>
            </div>
            <!-- /.logo-box -->
            <div class="mobile-nav__container"></div>
            <!-- /.mobile-nav__container -->

            <ul class="mobile-nav__contact list-unstyled">
                <li>
                    <i class="fa fa-envelope"></i>
                    <a href="mailto:info@vectorindia.org">info@vectorindia.org</a>
                </li>
                <li>
                    <i class="fa fa-phone-alt"></i>
                    <a href="tel:98666 66699">98666 66699</a>
                </li>
            </ul><!-- /.mobile-nav__contact -->
            <div class="mobile-nav__top">
                <div class="mobile-nav__social">
                    <a href="https://www.linkedin.com/company/vectorindia" target="_blank" class="linkedin"><i class="fab fa-linkedin"></i></a>
                    <a href="https://www.facebook.com/VectorInstitute" target="_blank" class="facebook"><i class="fab fa-facebook"></i></a>
                    <a href="https://twitter.com/Vector_India" target="_blank" class="twitter"><i class="fab fa-twitter"></i></a>
                    <a href="http://www.instagram.com/vectorindiainstitute" target="_blank" class="instagram"><i class="fab fa-instagram"></i></a>
                    <a href="https://wa.me/+919866666699" target="_blank" class="whatsapp"><i class="fab fa-whatsapp"></i></a>
                </div><!-- /.mobile-nav__social -->
            </div><!-- /.mobile-nav__top -->



        </div>
        <!-- /.mobile-nav__content -->
    </div>
    <!-- /.mobile-nav__wrapper -->

    <!-- Search Popup -->
    <div class="search-popup">
    <button class="close-search style-two"><span class="icon-cancel"></span></button>
    <button class="close-search"><span class="icon-up-arrow"></span></button>
    <form method="post" action="#">
        <div class="form-group">
            <input type="search" name="search-field" value="" placeholder="Search Here" required="">
            <button type="submit"><i class="fa fa-search"></i></button>
        </div>
    </form>
    </div>
    <!-- End Header Search -->

    <a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fa fa-angle-up"></i></a>


    <script src="/assets/vendors/jquery/jquery-3.6.0.min.js"></script>
    <script src="/assets/vendors/bootstrap/js/bootstrap.bundle.min.js"></script>
    
    <script src="/assets/vendors/jarallax/jarallax.min.js"></script>
    <script src="/assets/vendors/jquery-appear/jquery.appear.min.js"></script>
    <script src="/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js"></script>
    <script src="/assets/vendors/nouislider/nouislider.min.js"></script>
    <script src="/assets/vendors/odometer/odometer.min.js"></script>
    <script src="/assets/vendors/swiper/swiper.min.js"></script>
    <script src="/assets/vendors/tiny-slider/tiny-slider.min.js"></script>
    <script src="/assets/vendors/wnumb/wNumb.min.js"></script>
    <script src="/assets/vendors/wow/wow.js"></script>
    <script src="/assets/vendors/isotope/isotope.js"></script>
    <script src="/assets/vendors/owl-carousel/owl.carousel.min.js"></script>
    <script src="/assets/vendors/bxslider/jquery.bxslider.min.js"></script>
    <script src="/assets/vendors/bootstrap-select/js/bootstrap-select.min.js"></script>
    <script src="/assets/vendors/vegas/vegas.min.js"></script>
    <script src="/assets/vendors/jquery-ui/jquery-ui.js"></script>


    <!-- template js -->
    <script src="/assets/js/kontin.js"></script>

    <script src="/assets/js/enquiry-pop.js"></script>
    <script src="https://dev.sunaj.in/js/instagram-feed.js" crossorigin></script>
    <script type="text/javascript">
        window.onload = function (){
    $(".bts-popup").delay(1000).addClass('is-visible');
    }
    </script>

</body>
</html>
