// datetimeHelper.js

/**
 * Formats the current date/time in "dd-MMM-yyyy hh:mm a" format
 * Example: 14-Sep-2025 01:45 PM
 */
function getFormattedDateTime(now = new Date()) {

  return now.toLocaleString("en-IN", {
    day: "2-digit",
    month: "short",
    year: "numeric",
    hour: "2-digit",
    minute: "2-digit",
    hour12: true,
    timeZone: "Asia/Kolkata",
  });
}

module.exports = { getFormattedDateTime };