const jwt = require("jsonwebtoken");

function auth(req, res, next) {
  try {
    const token = req.header('Authorization')?.replace('Bearer ', '');

    if (!token) return res.status(401).json({ errorMessage: "Unauthorized." });

    const validatedUser = jwt.verify(token, process.env.JWT_SECRET);
    req.user = validatedUser.id;
    req.email = validatedUser.email;
    req.name = validatedUser.name;
    req.userMobile = validatedUser.mobile;
    req.roles = validatedUser.roles;
    req.pbx_extension = validatedUser.pbx_extension;
    req.pbx_port = validatedUser.pbx_port;
    next();
  } catch (err) {
    return res.status(401).json({ errorMessage: "Unauthorized." });
  }
}

module.exports = auth;
