const fs = require("fs");
const path = require("path");

module.exports = function htmlIncludeMiddleware(rootDir) {
    return function (req, res, next) {
        if (!req.path.endsWith(".html")) return next();

        const filePath = path.join(rootDir, req.path);
        console.log("filePath : ", filePath);
        fs.readFile(filePath, "utf8", (err, html) => {
            if (err) return next();

            // Pattern: <!--#include file="footer.html" -->
            const includeRegex = /<!--#include file="(.+?)" -->/g;

            let finalHtml = html.replace(includeRegex, (match, includeFile) => {
                const includePath = path.join(rootDir, includeFile);
                if (fs.existsSync(includePath)) {

                    const includeHtml = fs.readFileSync(includePath, "utf8");
                    if (includeFile.includes("footer.html")) {
                        const year = new Date().getFullYear();
                        return includeHtml.replace(/{{year}}/g, year);
                    }
                    return includeHtml;
                } else {
                    return `<!-- File not found: ${includeFile} -->`;
                }
            });

            // // Replace YEAR placeholder with server year
            // finalHtml = finalHtml.replace(/YEAR/g, new Date().getFullYear());

            res.set("Content-Type", "text/html");
            return res.send(finalHtml);
        });
    };
};